﻿/* http://keith-wood.name/calculator.html
   Calculator field entry extension for jQuery v1.3.1.
   Written by Keith Wood (kbwood{at}iinet.com.au) October 2008.
   Dual licensed under the GPL (http://dev.jquery.com/browser/trunk/jquery/GPL-LICENSE.txt) and 
   MIT (http://dev.jquery.com/browser/trunk/jquery/MIT-LICENSE.txt) licenses. 
   Please attribute the author if you use it. */
(function($){var s='calculator';function Calculator(){this._curInst=null;this._disabledFields=[];this._showingCalculator=false;this._showingKeystrokes=false;this._keyDefs={'_0':['0',this.digit,null,'','0','0'],'_1':['1',this.digit,null,'','1','1'],'_2':['2',this.digit,null,'','2','2'],'_3':['3',this.digit,null,'','3','3'],'_4':['4',this.digit,null,'','4','4'],'_5':['5',this.digit,null,'','5','5'],'_6':['6',this.digit,null,'','6','6'],'_7':['7',this.digit,null,'','7','7'],'_8':['8',this.digit,null,'','8','8'],'_9':['9',this.digit,null,'','9','9'],'_A':['A',this.digit,null,'hex-digit','A','a'],'_B':['B',this.digit,null,'hex-digit','B','b'],'_C':['C',this.digit,null,'hex-digit','C','c'],'_D':['D',this.digit,null,'hex-digit','D','d'],'_E':['E',this.digit,null,'hex-digit','E','e'],'_F':['F',this.digit,null,'hex-digit','F','f'],'_.':['.',this.digit,null,'decimal','DECIMAL','.'],'_+':['+',this.binary,this._add,'arith add','ADD','+'],'_-':['-',this.binary,this._subtract,'arith subtract','SUBTRACT','-'],'_*':['*',this.binary,this._multiply,'arith multiply','MULTIPLY','*'],'_/':['/',this.binary,this._divide,'arith divide','DIVIDE','/'],'_%':['%',this.unary,this._percent,'arith percent','PERCENT','%'],'_=':['=',this.unary,this._equals,'arith equals','EQUALS','='],'+-':['±',this.unary,this._plusMinus,'arith plus-minus','PLUS_MINUS','#'],'PI':['pi',this.unary,this._pi,'pi','PI','p'],'1X':['1/x',this.unary,this._inverse,'fn inverse','INV','i'],'LG':['log',this.unary,this._log,'fn log','LOG','l'],'LN':['ln',this.unary,this._ln,'fn ln','LN','n'],'EX':['eⁿ',this.unary,this._exp,'fn exp','EXP','E'],'SQ':['x²',this.unary,this._sqr,'fn sqr','SQR','@'],'SR':['√',this.unary,this._sqrt,'fn sqrt','SQRT','!'],'XY':['x^y',this.binary,this._power,'fn power','POWER','^'],'RN':['rnd',this.unary,this._random,'random','RANDOM','?'],'SN':['sin',this.unary,this._sin,'trig sin','SIN','s'],'CS':['cos',this.unary,this._cos,'trig cos','COS','o'],'TN':['tan',this.unary,this._tan,'trig tan','TAN','t'],'AS':['asin',this.unary,this._asin,'trig asin','ASIN','S'],'AC':['acos',this.unary,this._acos,'trig acos','ACOS','O'],'AT':['atan',this.unary,this._atan,'trig atan','ATAN','T'],'MC':['#memClear',this.unary,this._memClear,'memory mem-clear','MEM_CLEAR','x'],'MR':['#memRecall',this.unary,this._memRecall,'memory mem-recall','MEM_RECALL','r'],'MS':['#memStore',this.unary,this._memStore,'memory mem-store','MEM_STORE','m'],'M+':['#memAdd',this.unary,this._memAdd,'memory mem-add','MEM_ADD','>'],'M-':['#memSubtract',this.unary,this._memSubtract,'memory mem-subtract','MEM_SUBTRACT','<'],'BB':['#base2',this.control,this._base2,'base base2','BASE_2','B'],'BO':['#base8',this.control,this._base8,'base base8','BASE_8','C'],'BD':['#base10',this.control,this._base10,'base base10','BASE_10','D'],'BH':['#base16',this.control,this._base16,'base base16','BASE_16','H'],'DG':['#degrees',this.control,this._degrees,'angle degrees','DEGREES','G'],'RD':['#radians',this.control,this._radians,'angle radians','RADIANS','R'],'BS':['#backspace',this.control,this._undo,'undo','UNDO',8,'BSp'],'CE':['#clearError',this.control,this._clearError,'clear-error','CLEAR_ERROR',36,'Hom'],'CA':['#clear',this.control,this._clear,'clear','CLEAR',35,'End'],'@X':['#close',this.control,this._close,'close','CLOSE',27,'Esc'],'@U':['#use',this.control,this._use,'use','USE',13,'Ent'],'@E':['#erase',this.control,this._erase,'erase','ERASE',46,'Del'],'  ':['',this.space,null,'space','SPACE'],'_ ':['',this.space,null,'half-space','HALF_SPACE'],'??':['??',this.unary,this._noOp]};this._keyCodes={};this._keyChars={};for(var a in this._keyDefs){if(this._keyDefs[a][4]){this[this._keyDefs[a][4]]=a}if(this._keyDefs[a][5]){if(typeof this._keyDefs[a][5]=='number'){this._keyCodes[this._keyDefs[a][5]]=a}else{this._keyChars[this._keyDefs[a][5]]=a}}}this.regional=[];this.regional['']={decimalChar:'.',buttonText:'...',buttonStatus:'Open the calculator',closeText:'Close',closeStatus:'Close the calculator',useText:'Use',useStatus:'Use the current value',eraseText:'Erase',eraseStatus:'Erase the value from the field',backspaceText:'BS',backspaceStatus:'Erase the last digit',clearErrorText:'CE',clearErrorStatus:'Erase the last number',clearText:'CA',clearStatus:'Reset the calculator',memClearText:'MC',memClearStatus:'Clear the memory',memRecallText:'MR',memRecallStatus:'Recall the value from memory',memStoreText:'MS',memStoreStatus:'Store the value in memory',memAddText:'M+',memAddStatus:'Add to memory',memSubtractText:'M-',memSubtractStatus:'Subtract from memory',base2Text:'Bin',base2Status:'Switch to binary',base8Text:'Oct',base8Status:'Switch to octal',base10Text:'Dec',base10Status:'Switch to decimal',base16Text:'Hex',base16Status:'Switch to hexadecimal',degreesText:'Deg',degreesStatus:'Switch to degrees',radiansText:'Rad',radiansStatus:'Switch to radians',isRTL:false};this._defaults={showOn:'focus',buttonImage:'',buttonImageOnly:false,isOperator:null,showAnim:'show',showOptions:{},duration:'normal',appendText:'',useThemeRoller:false,calculatorClass:'',prompt:'',layout:this.standardLayout,value:0,base:10,precision:10,useDegrees:false,constrainInput:true,onOpen:null,onButton:null,onClose:null};$.extend(this._defaults,this.regional['']);this.mainDiv=$('<div class="'+this._mainDivClass+'" style="display: none;"></div>').click(this._focusEntry)}$.extend(Calculator.prototype,{markerClassName:'hasCalculator',digit:'d',binary:'b',unary:'u',control:'c',space:'s',_mainDivClass:'calculator-popup',_inlineClass:'calculator-inline',_appendClass:'calculator-append',_triggerClass:'calculator-trigger',_disableClass:'calculator-disabled',_inlineEntryClass:'calculator-keyentry',_resultClass:'calculator-result',_focussedClass:'calculator-focussed',_keystrokeClass:'calculator-keystroke',_coverClass:'calculator-cover',standardLayout:['  BSCECA','_1_2_3_+@X','_4_5_6_-@U','_7_8_9_*@E','_0_._=_/'],scientificLayout:['@X@U@E  BSCECA','DGRD    _ MC_ _7_8_9_+','SNASSRLG_ MR_ _4_5_6_-','CSACSQLN_ MS_ _1_2_3_*','TNATXYEX_ M+_ _0_.+-_/','PIRN1X  _ M-_   _%_='],setDefaults:function(a){extendRemove(this._defaults,a||{});return this},addKeyDef:function(a,b,c,d,e,f,g,h){this._keyDefs[a]=[b,(typeof c=='boolean'?(c?this.binary:this.unary):c),d,e,f,g,h];if(f){this[f]=a}if(g){if(typeof g=='number'){this._keyCodes[g]=a}else{this._keyChars[g]=a}}return this},_attachCalculator:function(a,b){var c=$(a);var d=a.nodeName.toLowerCase()!='input';var e=(!d?c:$('<input type="text" class="'+this._inlineEntryClass+'"/>'));var f={_input:e,_inline:d,_mainDiv:(d?$('<div class="'+this._inlineClass+'"></div>'):this.mainDiv)};f.settings=$.extend({},b||{});this._connectCalculator(a,f);if(d){c.append(e).append(f._mainDiv).bind('click.calculator',function(){e.focus()});this._reset(f,'0',true);this._setValue(f);this._updateCalculator(f)}else if($(a).is(':disabled')){this._disableCalculator(a)}},_connectCalculator:function(d,e){var f=$(d);if(f.hasClass(this.markerClassName)){return}var g=this._get(e,'appendText');var h=this._get(e,'isRTL');if(g){f[h?'before':'after']('<span class="'+this._appendClass+'">'+g+'</span>')}if(!e._inline){var i=this._get(e,'showOn');if(i=='focus'||i=='both'){f.focus(this._showCalculator)}if(i=='button'||i=='both'||i=='opbutton'){var j=this._get(e,'buttonText');var k=this._get(e,'buttonStatus');var l=this._get(e,'buttonImage');var m=$(this._get(e,'buttonImageOnly')?$('<img/>').attr({src:l,alt:k,title:k}):$('<button type="button" title="'+k+'"></button>').html(l==''?j:$('<img/>').attr({src:l})));f[h?'before':'after'](m);m.addClass(this._triggerClass).click(function(){if($.calculator._showingCalculator&&$.calculator._lastInput==d){$.calculator._hideCalculator()}else{$.calculator._showCalculator(d)}return false})}}e._input.keydown(this._doKeyDown).keyup(this._doKeyUp).keypress(this._doKeyPress);if(e._inline){e._mainDiv.keydown(this._doKeyDown).keyup(this._doKeyUp).keypress(this._doKeyPress);e._input.focus(function(){if(!$.calculator._isDisabledCalculator(f[0])){e._focussed=true;$('.'+$.calculator._resultClass,e._mainDiv).addClass($.calculator._focussedClass)}}).blur(function(){e._focussed=false;$('.'+$.calculator._resultClass,e._mainDiv).removeClass($.calculator._focussedClass)})}f.addClass(this.markerClassName).bind("setData.calculator",function(a,b,c){e.settings[b]=c}).bind("getData.calculator",function(a,b){return this._get(e,b)});$.data(d,s,e);$.data(e._input[0],s,e)},_destroyCalculator:function(a){var b=$(a);if(!b.hasClass(this.markerClassName)){return}var c=$.data(a,s);c._input.unbind('keydown',this._doKeyDown).unbind('keyup',this._doKeyUp).unbind('keypress',this._doKeyPress);b.siblings('.'+this._appendClass).remove().end().siblings('.'+this._triggerClass).remove().end().prev('.'+this._inlineEntryClass).remove().end().removeClass(this.markerClassName).unbind('focus',this._showCalculator).unbind('click.calculator').empty();$.removeData(c._input[0],s);$.removeData(a,s)},_enableCalculator:function(b){var c=$(b);if(!c.hasClass(this.markerClassName)){return}var d=b.nodeName.toLowerCase();if(d=='input'){b.disabled=false;c.siblings('button.'+this._triggerClass).each(function(){this.disabled=false}).end().siblings('img.'+this._triggerClass).css({opacity:'1.0',cursor:''})}else if(d=='div'||d=='span'){c.find('.'+this._inlineEntryClass+',button').attr('disabled','').end().children('.'+this._disableClass).remove()}this._disabledFields=$.map(this._disabledFields,function(a){return(a==b?null:a)})},_disableCalculator:function(b){var c=$(b);if(!c.hasClass(this.markerClassName)){return}var d=b.nodeName.toLowerCase();if(d=='input'){b.disabled=true;c.siblings('button.'+this._triggerClass).each(function(){this.disabled=true}).end().siblings('img.'+this._triggerClass).css({opacity:'0.5',cursor:'default'})}else if(d=='div'||d=='span'){var e=c.children('.'+this._inlineClass);var f=e.offset();var g={left:0,top:0};e.parents().each(function(){if($(this).css('position')=='relative'){g=$(this).offset();return false}});c.find('.'+this._inlineEntryClass+',button').attr('disabled','disabled').end().prepend('<div class="'+this._disableClass+'" style="width: '+e.outerWidth()+'px; height: '+e.outerHeight()+'px; left: '+(f.left-g.left)+'px; top: '+(f.top-g.top)+'px;"></div>')}this._disabledFields=$.map(this._disabledFields,function(a){return(a==b?null:a)});this._disabledFields[this._disabledFields.length]=b},_isDisabledCalculator:function(a){return(a&&$.inArray(a,this._disabledFields)>-1)},_changeCalculator:function(a,b,c){var d=b||{};if(typeof b=='string'){d={};d[b]=c}var e=$.data(a,s);if(e){if(this._curInst==e){this._hideCalculator()}extendRemove(e.settings,d);if(e._inline){this._setValue(e)}this._updateCalculator(e)}},_showCalculator:function(b){b=b.target||b;if($.calculator._isDisabledCalculator(b)||$.calculator._lastInput==b){return}var c=$.data(b,s);$.calculator._hideCalculator(null,'');$.calculator._lastInput=b;$.calculator._pos=$.calculator._findPos(b);$.calculator._pos[1]+=b.offsetHeight;var d=false;$(b).parents().each(function(){d|=$(this).css('position')=='fixed';return!d});if(d&&$.browser.opera){$.calculator._pos[0]-=document.documentElement.scrollLeft;$.calculator._pos[1]-=document.documentElement.scrollTop}var e={left:$.calculator._pos[0],top:$.calculator._pos[1]};$.calculator._pos=null;c._mainDiv.css({position:'absolute',display:'block',top:'-1000px',width:($.browser.opera?'1000px':'auto')});var f=$.calculator._get(c,'onOpen');if(f){f.apply((c._input?c._input[0]:null),[(c._inline?c.curValue:c._input.val()),c])}$.calculator._reset(c,c._input.val(),true);$.calculator._updateCalculator(c);e=$.calculator._checkOffset(c,e,d);c._mainDiv.css({position:(d?'fixed':'absolute'),display:'none',left:e.left+'px',top:e.top+'px'});var g=$.calculator._get(c,'showAnim');var h=$.calculator._get(c,'duration');h=(h=='normal'&&$.ui&&$.ui.version>='1.8'?'_default':h);var i=function(){$.calculator._showingCalculator=true;var a=$.calculator._getBorders(c._mainDiv);c._mainDiv.find('iframe.'+$.calculator._coverClass).css({left:-a[0],top:-a[1],width:c._mainDiv.outerWidth(),height:c._mainDiv.outerHeight()})};if($.effects&&$.effects[g]){var j=c._mainDiv.data();for(var k in j){if(k.match(/^ec\.storage\./)){j[k]=c._mainDiv.css(k.replace(/ec\.storage\./,''))}}c._mainDiv.data(j).show(g,$.calculator._get(c,'showOptions'),h,i)}else{c._mainDiv[g||'show']((g?h:''),i)}if(!g){i()}if(c._input[0].type!='hidden'){c._input[0].focus()}$.calculator._curInst=c},_reset:function(a,b,c){var d=this._get(a,'base');var e=this._get(a,'decimalChar');b=''+(b||0);b=(e!='.'?b.replace(new RegExp(e),'.'):b);a.curValue=(d==10?parseFloat(b):parseInt(b,d))||0;a.dispValue=this._setDisplay(a);a.prevValue=a._savedValue=0;a.memory=(c?0:a.memory);a._pendingOp=a._savedOp=this._noOp;a._newValue=true},_setValue:function(a){a.curValue=this._get(a,'value')||0;a.dispValue=this._setDisplay(a)},_updateCalculator:function(a){var b=this._getBorders(a._mainDiv);a._mainDiv.html(this._generateHTML(a)).find('iframe.'+this._coverClass).css({left:-b[0],top:-b[1],width:a._mainDiv.outerWidth(),height:a._mainDiv.outerHeight()});a._mainDiv.removeClass().addClass(this._get(a,'calculatorClass')+(this._get(a,'useThemeRoller')?' ui-widget ui-widget-content':'')+(this._get(a,'isRTL')?' calculator-rtl ':'')+' '+(a._inline?this._inlineClass:this._mainDivClass));if(this._curInst==a){a._input.focus()}},_getBorders:function(c){var d=function(a){var b=($.browser.msie?1:0);return{thin:1+b,medium:3+b,thick:5+b}[a]||a};return[parseFloat(d(c.css('border-left-width'))),parseFloat(d(c.css('border-top-width')))]},_checkOffset:function(a,b,c){var d=a._input?this._findPos(a._input[0]):null;var e=window.innerWidth||document.documentElement.clientWidth;var f=window.innerHeight||document.documentElement.clientHeight;var g=document.documentElement.scrollLeft||document.body.scrollLeft;var h=document.documentElement.scrollTop||document.body.scrollTop;if(($.browser.msie&&parseInt($.browser.version,10)<7)||$.browser.opera){var i=0;$('.calculator-row',a._mainDiv).find('button:last').each(function(){i=Math.max(i,this.offsetLeft+this.offsetWidth+parseInt($(this).css('margin-right'),10))});a._mainDiv.css('width',i)}if(this._get(a,'isRTL')||(b.left+a._mainDiv.outerWidth()-g)>e){b.left=Math.max((c?0:g),d[0]+(a._input?a._input.outerWidth():0)-(c?g:0)-a._mainDiv.outerWidth()-(c&&$.browser.opera?document.documentElement.scrollLeft:0))}else{b.left-=(c?g:0)}if((b.top+a._mainDiv.outerHeight()-h)>f){b.top=Math.max((c?0:h),d[1]-(c?h:0)-a._mainDiv.outerHeight()-(c&&$.browser.opera?document.documentElement.scrollTop:0))}else{b.top-=(c?h:0)}return b},_findPos:function(a){while(a&&(a.type=='hidden'||a.nodeType!=1)){a=a.nextSibling}var b=$(a).offset();return[b.left,b.top]},_hideCalculator:function(a,b){var c=this._curInst;if(!c||(a&&c!=$.data(a,s))){return}if(this._showingCalculator){b=(b!=null?b:this._get(c,'duration'));b=(b=='normal'&&$.ui&&$.ui.version>='1.8'?'_default':b);var d=this._get(c,'showAnim');if($.effects&&$.effects[d]){c._mainDiv.hide(d,this._get(c,'showOptions'),b)}else{c._mainDiv[(d=='slideDown'?'slideUp':(d=='fadeIn'?'fadeOut':'hide'))](d?b:'')}}var e=this._get(c,'onClose');if(e){e.apply((c._input?c._input[0]:null),[(c._inline?c.curValue:c._input.val()),c])}if(this._showingCalculator){this._showingCalculator=false;this._lastInput=null}this._curInst=null},_checkExternalClick:function(a){if(!$.calculator._curInst){return}var b=$(a.target);if(!b.parents().andSelf().hasClass($.calculator._mainDivClass)&&!b.hasClass($.calculator.markerClassName)&&!b.parents().andSelf().hasClass($.calculator._triggerClass)&&$.calculator._showingCalculator){$.calculator._hideCalculator()}},_focusEntry:function(){if($.calculator._curInst&&$.calculator._curInst._input){$.calculator._curInst._input.focus()}},_doKeyDown:function(e){var a=false;var b=$.data(e.target,s);var c=(b&&b._inline?$(e.target).parent()[0]:null);if(e.keyCode==9){$.calculator.mainDiv.stop(true,true);$.calculator._hideCalculator();if(b&&b._inline){b._input.blur()}}else if($.calculator._showingCalculator||(c&&!$.calculator._isDisabledCalculator(c))){if(e.keyCode==18){if(!$.calculator._showingKeystrokes){b._mainDiv.find('.'+$.calculator._keystrokeClass).show();$.calculator._showingKeystrokes=true}a=true}else{var d=$.calculator._keyCodes[e.keyCode];if(d){$('button[keystroke='+d+']',b._mainDiv).not(':disabled').click();a=true}}}else if(e.keyCode==36&&e.ctrlKey&&b&&!b._inline){$.calculator._showCalculator(this)}if(a){e.preventDefault();e.stopPropagation()}return!a},_doKeyUp:function(e){if($.calculator._showingKeystrokes){var a=$.data(e.target,s);a._mainDiv.find('.'+$.calculator._keystrokeClass).hide();$.calculator._showingKeystrokes=false}},_doKeyPress:function(e){var a=$.data(e.target,s);if(!a){return true}var b=(a&&a._inline?$(e.target).parent()[0]:null);var c=String.fromCharCode(e.charCode==undefined?e.keyCode:e.charCode);var d=$.calculator._get(a,'base');var f=$.calculator._get(a,'decimalChar');var g=$.calculator._get(a,'showOn');var h=$.calculator._get(a,'isOperator')||$.calculator._isOperator;if(!$.calculator._showingCalculator&&!b&&(g=='operator'||g=='opbutton')&&h.apply(a._input,[c,e,a._input.val(),d,f])){$.calculator._showCalculator(this);$.calculator._showingCalculator=true}if($.calculator._showingCalculator||(b&&!$.calculator._isDisabledCalculator(b))){var i=$.calculator._keyChars[c==f?'.':c];if(i){$('button[keystroke='+i+']',a._mainDiv).not(':disabled').click()}return false}if(c>=' '&&$.calculator._get(a,'constrainInput')){var j=new RegExp('^-?'+(d==10?'[0-9]*(\\'+f+'[0-9]*)?':'['+'0123456789abcdef'.substring(0,d)+']*')+'$');return(a._input.val()+c).toLowerCase().match(j)!=null}return true},_isOperator:function(a,b,c,d,e){return a>' '&&!(a=='-'&&c=='')&&('0123456789abcdef'.substr(0,d)+'.'+e).indexOf(a.toLowerCase())==-1},_get:function(a,b){return a.settings[b]!==undefined?a.settings[b]:this._defaults[b]},_generateHTML:function(a){var b=this._get(a,'useThemeRoller');var c=this._get(a,'isRTL');var d=this._get(a,'prompt');var e=this._get(a,'layout');var f=this._get(a,'base');var g=this._get(a,'useDegrees');var h=(!d?'':'<div class="calculator-prompt'+(b?' ui-widget-header ui-corner-all':'')+'">'+d+'</div>')+'<div class="calculator-result'+(b?' ui-widget-header':'')+(a._focussed?' '+this._focussedClass:'')+'"><span>'+a.dispValue+'</span></div>';for(var i=0;i<e.length;i++){h+='<div class="calculator-row">';for(var j=0;j<e[i].length;j+=2){var l=e[i].substr(j,2);var m=this._keyDefs[l]||this._keyDefs['??'];var n=(m[0].charAt(0)=='#'?this._get(a,m[0].substr(1)+'Text'):m[0]);var o=(m[0].charAt(0)=='#'?this._get(a,m[0].substr(1)+'Status'):'');var p=(m[3]?m[3].split(' '):[]);for(var k=0;k<p.length;k++){p[k]='calculator-'+p[k]}p=p.join(' ');var q=(b?' ui-state-active':'');var r=(b?' ui-state-highlight':'');h+=(m[1]==this.space?'<span class="calculator-'+m[3]+'"></span>':(a._inline&&(m[2]=='._close'||m[2]=='._erase')?'':'<button type="button" keystroke="'+l+'"'+(m[1]==this.control?' class="calculator-ctrl'+(m[0].match(/^#base/)?(m[0].replace(/^#base/,'')==f?q||' calculator-base-active':r):(m[0]=='#degrees'?(g?q||' calculator-angle-active':r):(m[0]=='#radians'?(!g?q||' calculator-angle-active':r):r))):(m[1]==this.digit?(parseInt(m[0],16)>=f||(f!=10&&m[0]=='.')?' disabled="disabled"':'')+' class="calculator-digit':(m[1]==this.binary?' class="calculator-oper':' class="calculator-oper'+(m[0].match(/^#mem(Clear|Recall)$/)&&!a.memory?' calculator-mem-empty':''))))+(b?' ui-state-default':'')+(p?' '+p:'')+'" '+(o?'title="'+o+'"':'')+'>'+(l=='_.'?this._get(a,'decimalChar'):n)+(m[5]&&m[5]!=m[0]?'<span class="'+this._keystrokeClass+(b?' ui-state-error':'')+(m[6]?' calculator-keyname':'')+'">'+(m[6]||m[5])+'</span>':'')+'</button>'))}h+='</div>'}h+='<div style="clear: both;"></div>'+(!a._inline&&$.browser.msie&&parseInt($.browser.version,10)<7?'<iframe src="javascript:false;" class="'+this._coverClass+'"></iframe>':'');h=$(h);h.find('button').mouseover(function(){$.calculator._saveClasses=this.className}).mousedown(function(){$(this).addClass('calculator-key-down'+(b?' ui-state-active':''))}).mouseup(function(){$(this).removeClass().addClass($.calculator._saveClasses)}).mouseout(function(){$(this).removeClass().addClass($.calculator._saveClasses)}).click(function(){$.calculator._handleButton(a,$(this))});return h},_setDisplay:function(a){var b=this._get(a,'precision');var c=new Number(a.curValue).toFixed(b).valueOf();var d=c.replace(/^.+(e.+)$/,'$1').replace(/^[^e].*$/,'');if(d){c=new Number(c.replace(/e.+$/,'')).toFixed(b).valueOf()}return parseFloat(c.replace(/0+$/,'')+d).toString(this._get(a,'base')).toUpperCase().replace(/\./,this._get(a,'decimalChar'))},_sendButton:function(a,b){var c=this._get(a,'onButton');if(c){c.apply((a._input?a._input[0]:null),[b,a.dispValue,a])}},_handleButton:function(a,b){var c=this._keyDefs[b.attr('keystroke')];if(!c){return}var d=b.text().substr(0,b.text().length-b.children('.calculator-keystroke').text().length);switch(c[1]){case this.control:c[2].apply(this,[a,d]);break;case this.digit:this._digit(a,d);break;case this.binary:this._binaryOp(a,c[2],d);break;case this.unary:this._unaryOp(a,c[2],d);break}if($.calculator._showingCalculator||a._inline){a._input.focus()}},_noOp:function(a){},_digit:function(a,b){var c=this._get(a,'decimalChar');a.dispValue=(a._newValue?'':a.dispValue);if(b==c&&a.dispValue.indexOf(b)>-1){return}a.dispValue=(a.dispValue+b).replace(/^0(\d)/,'$1').replace(new RegExp('^(-?)([\\.'+c+'])'),'$10$2');if(c!='.'){a.dispValue=a.dispValue.replace(new RegExp('^'+c),'0.')}var d=this._get(a,'base');var e=(c!='.'?a.dispValue.replace(new RegExp(c),'.'):a.dispValue);a.curValue=(d==10?parseFloat(e):parseInt(e,d));a._newValue=false;this._sendButton(a,b);this._updateCalculator(a)},_binaryOp:function(a,b,c){if(!a._newValue&&a._pendingOp){a._pendingOp(a);var d=this._get(a,'base');a.curValue=(d==10?a.curValue:Math.floor(a.curValue));a.dispValue=this._setDisplay(a)}a.prevValue=a.curValue;a._newValue=true;a._pendingOp=b;this._sendButton(a,c);this._updateCalculator(a)},_add:function(a){a.curValue=a.prevValue+a.curValue},_subtract:function(a){a.curValue=a.prevValue-a.curValue},_multiply:function(a){a.curValue=a.prevValue*a.curValue},_divide:function(a){a.curValue=a.prevValue/a.curValue},_power:function(a){a.curValue=Math.pow(a.prevValue,a.curValue)},_unaryOp:function(a,b,c){a._newValue=true;b.apply(this,[a]);var d=this._get(a,'base');a.curValue=(d==10?a.curValue:Math.floor(a.curValue));a.dispValue=this._setDisplay(a);this._sendButton(a,c);this._updateCalculator(a)},_plusMinus:function(a){a.curValue=-1*a.curValue;a.dispValue=this._setDisplay(a);a._newValue=false},_pi:function(a){a.curValue=Math.PI},_percent:function(a){if(a._pendingOp==this._add){a.curValue=a.prevValue*(1+a.curValue/100)}else if(a._pendingOp==this._subtract){a.curValue=a.prevValue*(1-a.curValue/100)}else if(a._pendingOp==this._multiply){a.curValue=a.prevValue*a.curValue/100}else if(a._pendingOp==this._divide){a.curValue=a.prevValue/a.curValue*100}a._savedOp=a._pendingOp;a._pendingOp=this._noOp},_equals:function(a){if(a._pendingOp==this._noOp){if(a._savedOp!=this._noOp){a.prevValue=a.curValue;a.curValue=a._savedValue;a._savedOp(a)}}else{a._savedOp=a._pendingOp;a._savedValue=a.curValue;a._pendingOp(a);a._pendingOp=this._noOp}},_memAdd:function(a){a.memory+=a.curValue},_memSubtract:function(a){a.memory-=a.curValue},_memStore:function(a){a.memory=a.curValue},_memRecall:function(a){a.curValue=a.memory},_memClear:function(a){a.memory=0},_sin:function(a){this._trig(a,Math.sin)},_cos:function(a){this._trig(a,Math.cos)},_tan:function(a){this._trig(a,Math.tan)},_trig:function(a,b){var c=this._get(a,'useDegrees');a.curValue=b(a.curValue*(c?Math.PI/180:1))},_asin:function(a){this._atrig(a,Math.asin)},_acos:function(a){this._atrig(a,Math.acos)},_atan:function(a){this._atrig(a,Math.atan)},_atrig:function(a,b){a.curValue=b(a.curValue);if(this._get(a,'useDegrees')){a.curValue=a.curValue/Math.PI*180}},_inverse:function(a){a.curValue=1/a.curValue},_log:function(a){a.curValue=Math.log(a.curValue)/Math.log(10)},_ln:function(a){a.curValue=Math.log(a.curValue)},_exp:function(a){a.curValue=Math.exp(a.curValue)},_sqr:function(a){a.curValue*=a.curValue},_sqrt:function(a){a.curValue=Math.sqrt(a.curValue)},_random:function(a){a.curValue=Math.random()},_base2:function(a,b){this._changeBase(a,b,2)},_base8:function(a,b){this._changeBase(a,b,8)},_base10:function(a,b){this._changeBase(a,b,10)},_base16:function(a,b){this._changeBase(a,b,16)},_changeBase:function(a,b,c){a.settings.base=c;a.curValue=(c==10?a.curValue:Math.floor(a.curValue));a.dispValue=this._setDisplay(a);a._newValue=true;this._sendButton(a,b);this._updateCalculator(a)},_degrees:function(a,b){this._degreesRadians(a,b,true)},_radians:function(a,b){this._degreesRadians(a,b,false)},_degreesRadians:function(a,b,c){a.settings.useDegrees=c;this._sendButton(a,b);this._updateCalculator(a)},_undo:function(a,b){a.dispValue=a.dispValue.substr(0,a.dispValue.length-1)||'0';var c=this._get(a,'base');a.curValue=(c==10?parseFloat(a.dispValue):parseInt(a.dispValue,c));this._sendButton(a,b);this._updateCalculator(a)},_clearError:function(a,b){a.dispValue='0';a.curValue=0;a._newValue=true;this._sendButton(a,b);this._updateCalculator(a)},_clear:function(a,b){this._reset(a,0,false);this._sendButton(a,b);this._updateCalculator(a)},_close:function(a,b){this._finished(a,b,a._input.val())},_use:function(a,b){if(a._pendingOp!=this._noOp){this._unaryOp(a,this._equals,b)}this._finished(a,b,a.dispValue)},_erase:function(a,b){this._reset(a,0,false);this._updateCalculator(a);this._finished(a,b,'')},_finished:function(a,b,c){if(a._inline){this._curInst=a}else{a._input.val(c)}this._sendButton(a,b);this._hideCalculator(a._input[0])}});function extendRemove(a,b){$.extend(a,b);for(var c in b){if(b[c]==null||b[c]==undefined){a[c]=b[c]}}return a}$.fn.calculator=function(a){var b=Array.prototype.slice.call(arguments,1);if(a=='isDisabled'){return $.calculator['_'+a+'Calculator'].apply($.calculator,[this[0]].concat(b))}return this.each(function(){typeof a=='string'?$.calculator['_'+a+'Calculator'].apply($.calculator,[this].concat(b)):$.calculator._attachCalculator(this,a)})};$.calculator=new Calculator();$(function(){$(document.body).append($.calculator.mainDiv).mousedown($.calculator._checkExternalClick)})})(jQuery);